<?php

use Drupal\views\Entity\View;

if (PHP_SAPI !== 'cli') {
  throw new \Exception('This script must be run via Drush: drush scr web/custom_site_views_setup.php');
}

print "=== Custom Site Views Setup (fixed) ===\n";

/**
 * Helper: build a simple node list view config array.
 */
function build_simple_node_view_config($id, $label, $content_type, $path, $page_title, $with_block = TRUE) {
  $display = [];

  // Default (master) display.
  $display['default'] = [
    'id' => 'default',
    'display_title' => 'Master',
    'display_plugin' => 'default',
    'position' => 0,
    'display_options' => [
      'access' => [
        'type' => 'perm',
        'options' => ['perm' => 'access content'],
      ],
      'cache' => [
        'type' => 'tag',
        'options' => [],
      ],
      'query' => [
        'type' => 'views_query',
        'options' => [],
      ],
      'exposed_form' => [
        'type' => 'basic',
        'options' => [],
      ],
      'pager' => [
        'type' => 'full',
        'options' => [
          'items_per_page' => 10,
        ],
      ],
      'style' => [
        'type' => 'default',
        'options' => [],
      ],
      'row' => [
        'type' => 'fields',
        'options' => [],
      ],
      'fields' => [
        'title' => [
          'id' => 'title',
          'table' => 'node_field_data',
          'field' => 'title',
          'plugin_id' => 'field',
          'label' => '',
        ],
      ],
      'filters' => [
        'status' => [
          'id' => 'status',
          'table' => 'node_field_data',
          'field' => 'status',
          'value' => 1,
          'plugin_id' => 'boolean',
        ],
        'type' => [
          'id' => 'type',
          'table' => 'node_field_data',
          'field' => 'type',
          'value' => [$content_type => $content_type],
          'plugin_id' => 'bundle',
        ],
      ],
      'sorts' => [
        'created' => [
          'id' => 'created',
          'table' => 'node_field_data',
          'field' => 'created',
          'order' => 'DESC',
          'plugin_id' => 'date',
        ],
      ],
    ],
  ];

  // Page display.
  $display['page_1'] = [
    'id' => 'page_1',
    'display_title' => 'Page',
    'display_plugin' => 'page',
    'position' => 1,
    'display_options' => [
      'path' => ltrim($path, '/'),
      'title' => $page_title,
      'access' => [
        'type' => 'perm',
        'options' => ['perm' => 'access content'],
      ],
    ],
  ];

  // Optional block display (للهوم).
  if ($with_block) {
    $display['block_1'] = [
      'id' => 'block_1',
      'display_title' => 'Block',
      'display_plugin' => 'block',
      'position' => 2,
      'display_options' => [
        'pager' => [
          'type' => 'some',
          'options' => [
            'items_per_page' => 3,
          ],
        ],
      ],
    ];
  }

  return [
    'id' => $id,
    'label' => $label,
    'module' => 'views',
    'description' => '',
    'tag' => '',
    'base_table' => 'node_field_data',
    'base_field' => 'nid',
    'core' => '8.x',
    'status' => TRUE,
    'display' => $display,
  ];
}

/**
 * Create simple node view if it does not exist.
 */
function create_simple_node_view($id, $label, $content_type, $path, $page_title, $with_block = TRUE) {
  if (View::load($id)) {
    print "View '$id' already exists, skipping.\n";
    return;
  }

  $config = build_simple_node_view_config($id, $label, $content_type, $path, $page_title, $with_block);
  $view = View::create($config);
  $view->save();
  print "Created view: $id\n";
}

/**
 * Build config for org_info_section view.
 */
function build_org_info_view_config() {
  $display = [];

  $display['default'] = [
    'id' => 'default',
    'display_title' => 'Master',
    'display_plugin' => 'default',
    'position' => 0,
    'display_options' => [
      'access' => [
        'type' => 'perm',
        'options' => ['perm' => 'access content'],
      ],
      'cache' => [
        'type' => 'tag',
        'options' => [],
      ],
      'query' => [
        'type' => 'views_query',
        'options' => [],
      ],
      'exposed_form' => [
        'type' => 'basic',
        'options' => [],
      ],
      'pager' => [
        'type' => 'none',
        'options' => [
          'items_per_page' => 0,
        ],
      ],
      'style' => [
        'type' => 'default',
        'options' => [],
      ],
      'row' => [
        'type' => 'fields',
        'options' => [],
      ],
      'fields' => [
        'title' => [
          'id' => 'title',
          'table' => 'node_field_data',
          'field' => 'title',
          'plugin_id' => 'field',
          'label' => '',
        ],
        'body' => [
          'id' => 'body',
          'table' => 'node__body',
          'field' => 'body',
          'plugin_id' => 'field',
          'label' => '',
        ],
      ],
      'filters' => [
        'status' => [
          'id' => 'status',
          'table' => 'node_field_data',
          'field' => 'status',
          'value' => 1,
          'plugin_id' => 'boolean',
        ],
        'type' => [
          'id' => 'type',
          'table' => 'node_field_data',
          'field' => 'type',
          'value' => ['org_info_section' => 'org_info_section'],
          'plugin_id' => 'bundle',
        ],
      ],
      // تقدر بعدين من الـ UI تغيّر الـ sort إلى field_org_weight.
      'sorts' => [
        'created' => [
          'id' => 'created',
          'table' => 'node_field_data',
          'field' => 'created',
          'order' => 'ASC',
          'plugin_id' => 'date',
        ],
      ],
    ],
  ];

  // Page اختيارية لعرض الأقسام في صفحة مستقلة.
  $display['page_1'] = [
    'id' => 'page_1',
    'display_title' => 'Page',
    'display_plugin' => 'page',
    'position' => 1,
    'display_options' => [
      'path' => 'about/sections',
      'title' => 'Organization info sections',
      'access' => [
        'type' => 'perm',
        'options' => ['perm' => 'access content'],
      ],
    ],
  ];

  // Block لاستخدامه في الهوم أو صفحة من نحن.
  $display['block_1'] = [
    'id' => 'block_1',
    'display_title' => 'Block',
    'display_plugin' => 'block',
    'position' => 2,
    'display_options' => [],
  ];

  return [
    'id' => 'view_org_info_sections',
    'label' => 'Organization info sections',
    'module' => 'views',
    'description' => '',
    'tag' => '',
    'base_table' => 'node_field_data',
    'base_field' => 'nid',
    'core' => '8.x',
    'status' => TRUE,
    'display' => $display,
  ];
}

/**
 * Create org_info_section view.
 */
function create_org_info_view() {
  if (View::load('view_org_info_sections')) {
    print "View 'view_org_info_sections' already exists, skipping.\n";
    return;
  }

  $config = build_org_info_view_config();
  $view = View::create($config);
  $view->save();
  print "Created view: view_org_info_sections\n";
}

/* ==========================================================================
 * Execution
 * ======================================================================== */

print "--- Creating views for news / announcements / events / team activities ---\n";

create_simple_node_view(
  'view_news',
  'News',
  'news',
  '/news',
  'News',
  TRUE
);

create_simple_node_view(
  'view_announcements',
  'Announcements',
  'announcement',
  '/announcements',
  'Announcements',
  TRUE
);

create_simple_node_view(
  'view_events',
  'Events',
  'event',
  '/events',
  'Events',
  TRUE
);

create_simple_node_view(
  'view_team_activities',
  'Team activities',
  'team_activity',
  '/activities',
  'Team activities',
  TRUE
);

print "--- Creating org_info_section view ---\n";
create_org_info_view();

print "=== DONE: Views created. Check /admin/structure/views ===\n";
